import 'package:flutter/material.dart';
import 'package:get/get.dart';

import 'package:play_lab/constants/my_strings.dart';
import 'package:play_lab/core/utils/dimensions.dart';
import 'package:play_lab/core/utils/my_color.dart';
import 'package:play_lab/core/utils/styles.dart';
import 'package:play_lab/core/utils/url_container.dart';

import 'package:play_lab/data/controller/request/make_request_controller.dart';
import 'package:play_lab/data/repo/request/request_repo.dart';
import 'package:play_lab/data/services/api_service.dart';

import 'package:play_lab/view/components/app_bar/custom_appbar.dart';
import 'package:play_lab/view/components/bottom-sheet/custom_bottom_sheet.dart';
import 'package:play_lab/view/components/custom_loader/custom_loader.dart';
import 'package:play_lab/view/components/custom_text_field.dart';
import 'package:play_lab/view/components/image/my_image_widget.dart';
import 'package:play_lab/view/components/text_field_container2.dart';
import 'package:play_lab/view/screens/request/widget/request_bottom_sheet_body.dart';

class MakeRequestScreen extends StatefulWidget {
  const MakeRequestScreen({super.key});

  @override
  State<MakeRequestScreen> createState() => _MakeRequestScreenState();
}

class _MakeRequestScreenState extends State<MakeRequestScreen> {
  late TextEditingController searchController;
  @override
  void initState() {
    searchController = TextEditingController();
    Get.put(ApiClient(sharedPreferences: Get.find()));
    Get.put(RequestRepo(apiClient: Get.find()));
    final controller = Get.put(MakeRequestController(repo: Get.find()));
    super.initState();
    WidgetsBinding.instance.addPostFrameCallback((t) {
      controller.initialValue();
    });
  }

  @override
  void dispose() {
    searchController.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: MyColor.colorBlack,
      appBar: CustomAppBar(title: MyStrings.makeRequest),
      body: GetBuilder<MakeRequestController>(
        builder: (controller) {
          return Padding(
            padding: Dimensions.screenPaddingHV,
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                TextFieldContainer2(
                  onTap: () {},
                  fillColor: MyColor.cardBg,
                  child: Row(
                    children: [
                      Expanded(
                        child: CustomTextField(
                          onChanged: (v) {},
                          hintText: "${MyStrings.searchHere.tr}...",
                          controller: searchController,
                          onSubmit: () => controller.searchRequest(searchController.text),
                        ),
                      ),
                      SizedBox(width: Dimensions.space5),
                      InkWell(
                        onTap: () {
                          controller.searchRequest(searchController.text);
                        },
                        child: Container(
                          padding: EdgeInsets.all(Dimensions.space15),
                          decoration: BoxDecoration(
                            color: MyColor.primaryColor,
                            borderRadius: BorderRadius.circular(Dimensions.cardRadius),
                          ),
                          child: Icon(Icons.search),
                        ),
                      ),
                    ],
                  ),
                ),
                SizedBox(height: Dimensions.space30),
                if (controller.items.isEmpty) ...[],
                if (controller.isSearching) ...[Expanded(child: CustomLoader())],
                if (!controller.isSearching && controller.searchItems.isNotEmpty) ...[
                  Expanded(
                    child: ListView.separated(
                      shrinkWrap: true,
                      itemCount: controller.searchItems.length,
                      separatorBuilder: (context, index) => SizedBox(height: Dimensions.space20),
                      itemBuilder: (context, index) {
                        final srcItem = controller.searchItems[index];
                        return Container(
                          padding: EdgeInsets.all(Dimensions.space10),
                          decoration: BoxDecoration(color: MyColor.cardBg, borderRadius: BorderRadius.circular(Dimensions.cardRadius)),
                          child: Row(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              MyImageWidget(
                                imageUrl: "${UrlContainer.tmdSearchImagePath}${srcItem.posterPath}",
                                height: 180,
                                width: 120,
                              ),
                              SizedBox(width: Dimensions.space20),
                              Expanded(
                                child: Column(
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  mainAxisAlignment: MainAxisAlignment.end,
                                  children: [
                                    Text(srcItem.title ?? "--", style: regularDefault.copyWith(fontSize: Dimensions.fontExtraLarge, color: MyColor.primaryColor)),
                                    SizedBox(height: Dimensions.space5),
                                    Text(srcItem.overview ?? '--', style: mulishLight.copyWith(color: MyColor.primaryText2), maxLines: 4, overflow: TextOverflow.ellipsis),
                                    SizedBox(height: Dimensions.space50),
                                    Row(
                                      mainAxisAlignment: MainAxisAlignment.end,
                                      children: [
                                        InkWell(
                                          onTap: () {
                                            CustomBottomSheet(
                                              bgColor: MyColor.bgColor,
                                              child: RequestBottomSheetBody(
                                                item: srcItem,
                                                callback: () {
                                                  searchController.text = "";
                                                  setState(() {});
                                                },
                                              ),
                                            ).customBottomSheet(context);
                                          },
                                          child: Container(
                                            padding: EdgeInsets.symmetric(horizontal: Dimensions.space20, vertical: Dimensions.space5),
                                            decoration: BoxDecoration(color: MyColor.primaryColor, borderRadius: BorderRadius.circular(Dimensions.cardRadius)),
                                            child: Text(MyStrings.request.tr, style: regularDefault.copyWith(color: MyColor.colorWhite)),
                                          ),
                                        ),
                                      ],
                                    )
                                  ],
                                ),
                              )
                            ],
                          ),
                        );
                      },
                    ),
                  )
                ],
              ],
            ),
          );
        },
      ),
    );
  }
}
